/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterNode
implements ToCopyableBuilder<Builder, ClusterNode> {
    private final String nodeRole;
    private final String privateIPAddress;
    private final String publicIPAddress;

    private ClusterNode(BuilderImpl builder) {
        this.nodeRole = builder.nodeRole;
        this.privateIPAddress = builder.privateIPAddress;
        this.publicIPAddress = builder.publicIPAddress;
    }

    public String nodeRole() {
        return this.nodeRole;
    }

    public String privateIPAddress() {
        return this.privateIPAddress;
    }

    public String publicIPAddress() {
        return this.publicIPAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIPAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIPAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode other = (ClusterNode)obj;
        return Objects.equals(this.nodeRole(), other.nodeRole()) && Objects.equals(this.privateIPAddress(), other.privateIPAddress()) && Objects.equals(this.publicIPAddress(), other.publicIPAddress());
    }

    public String toString() {
        return ToString.builder((String)"ClusterNode").add("NodeRole", (Object)this.nodeRole()).add("PrivateIPAddress", (Object)this.privateIPAddress()).add("PublicIPAddress", (Object)this.publicIPAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeRole": {
                return Optional.of(clazz.cast(this.nodeRole()));
            }
            case "PrivateIPAddress": {
                return Optional.of(clazz.cast(this.privateIPAddress()));
            }
            case "PublicIPAddress": {
                return Optional.of(clazz.cast(this.publicIPAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeRole;
        private String privateIPAddress;
        private String publicIPAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNode model) {
            this.nodeRole(model.nodeRole);
            this.privateIPAddress(model.privateIPAddress);
            this.publicIPAddress(model.publicIPAddress);
        }

        public final String getNodeRole() {
            return this.nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        public final String getPrivateIPAddress() {
            return this.privateIPAddress;
        }

        @Override
        public final Builder privateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
            return this;
        }

        public final void setPrivateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
        }

        public final String getPublicIPAddress() {
            return this.publicIPAddress;
        }

        @Override
        public final Builder publicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
            return this;
        }

        public final void setPublicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
        }

        public ClusterNode build() {
            return new ClusterNode(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterNode> {
        public Builder nodeRole(String var1);

        public Builder privateIPAddress(String var1);

        public Builder publicIPAddress(String var1);
    }
}

