/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AuthorizeClusterSecurityGroupIngressRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, AuthorizeClusterSecurityGroupIngressRequest> {
    private final String clusterSecurityGroupName;
    private final String cidrip;
    private final String ec2SecurityGroupName;
    private final String ec2SecurityGroupOwnerId;

    private AuthorizeClusterSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.cidrip = builder.cidrip;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    public String clusterSecurityGroupName() {
        return this.clusterSecurityGroupName;
    }

    public String cidrip() {
        return this.cidrip;
    }

    public String ec2SecurityGroupName() {
        return this.ec2SecurityGroupName;
    }

    public String ec2SecurityGroupOwnerId() {
        return this.ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrip());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2SecurityGroupOwnerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeClusterSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeClusterSecurityGroupIngressRequest other = (AuthorizeClusterSecurityGroupIngressRequest)((Object)obj);
        return Objects.equals(this.clusterSecurityGroupName(), other.clusterSecurityGroupName()) && Objects.equals(this.cidrip(), other.cidrip()) && Objects.equals(this.ec2SecurityGroupName(), other.ec2SecurityGroupName()) && Objects.equals(this.ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    public String toString() {
        return ToString.builder((String)"AuthorizeClusterSecurityGroupIngressRequest").add("ClusterSecurityGroupName", (Object)this.clusterSecurityGroupName()).add("CIDRIP", (Object)this.cidrip()).add("EC2SecurityGroupName", (Object)this.ec2SecurityGroupName()).add("EC2SecurityGroupOwnerId", (Object)this.ec2SecurityGroupOwnerId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSecurityGroupName": {
                return Optional.of(clazz.cast(this.clusterSecurityGroupName()));
            }
            case "CIDRIP": {
                return Optional.of(clazz.cast(this.cidrip()));
            }
            case "EC2SecurityGroupName": {
                return Optional.of(clazz.cast(this.ec2SecurityGroupName()));
            }
            case "EC2SecurityGroupOwnerId": {
                return Optional.of(clazz.cast(this.ec2SecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterSecurityGroupName;
        private String cidrip;
        private String ec2SecurityGroupName;
        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeClusterSecurityGroupIngressRequest model) {
            this.clusterSecurityGroupName(model.clusterSecurityGroupName);
            this.cidrip(model.cidrip);
            this.ec2SecurityGroupName(model.ec2SecurityGroupName);
            this.ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getClusterSecurityGroupName() {
            return this.clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        public final String getCIDRIP() {
            return this.cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final void setCIDRIP(String cidrip) {
            this.cidrip = cidrip;
        }

        public final String getEC2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final void setEC2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        public final String getEC2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final void setEC2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeClusterSecurityGroupIngressRequest build() {
            return new AuthorizeClusterSecurityGroupIngressRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, AuthorizeClusterSecurityGroupIngressRequest> {
        public Builder clusterSecurityGroupName(String var1);

        public Builder cidrip(String var1);

        public Builder ec2SecurityGroupName(String var1);

        public Builder ec2SecurityGroupOwnerId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

