/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;

public class RotateEncryptionKeyRequestMarshaller
implements Marshaller<Request<RotateEncryptionKeyRequest>, RotateEncryptionKeyRequest> {
    public Request<RotateEncryptionKeyRequest> marshall(RotateEncryptionKeyRequest rotateEncryptionKeyRequest) {
        if (rotateEncryptionKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)rotateEncryptionKeyRequest, "RedshiftClient");
        request.addParameter("Action", "RotateEncryptionKey");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (rotateEncryptionKeyRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)rotateEncryptionKeyRequest.clusterIdentifier()));
        }
        return request;
    }
}

