/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.EventCategoriesMap;
import software.amazon.awssdk.services.redshift.model.EventInfoMap;
import software.amazon.awssdk.services.redshift.transform.EventInfoMapUnmarshaller;

public class EventCategoriesMapUnmarshaller
implements Unmarshaller<EventCategoriesMap, StaxUnmarshallerContext> {
    private static final EventCategoriesMapUnmarshaller INSTANCE = new EventCategoriesMapUnmarshaller();

    public EventCategoriesMap unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventCategoriesMap.Builder eventCategoriesMap;
        block6: {
            eventCategoriesMap = EventCategoriesMap.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<EventInfoMap> events = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    eventCategoriesMap.events(events);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("SourceType", targetDepth)) {
                        eventCategoriesMap.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Events", targetDepth)) {
                        events = new ArrayList<EventInfoMap>();
                        continue;
                    }
                    if (!context.testExpression("Events/EventInfoMap", targetDepth)) continue;
                    events.add(EventInfoMapUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            eventCategoriesMap.events(events);
        }
        return (EventCategoriesMap)eventCategoriesMap.build();
    }

    public static EventCategoriesMapUnmarshaller getInstance() {
        return INSTANCE;
    }
}

