/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateHsmConfigurationRequestMarshaller
implements Marshaller<Request<CreateHsmConfigurationRequest>, CreateHsmConfigurationRequest> {
    public Request<CreateHsmConfigurationRequest> marshall(CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        List<Tag> tagsList;
        if (createHsmConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createHsmConfigurationRequest, "RedshiftClient");
        request.addParameter("Action", "CreateHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createHsmConfigurationRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)createHsmConfigurationRequest.hsmConfigurationIdentifier()));
        }
        if (createHsmConfigurationRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createHsmConfigurationRequest.description()));
        }
        if (createHsmConfigurationRequest.hsmIpAddress() != null) {
            request.addParameter("HsmIpAddress", StringUtils.fromString((String)createHsmConfigurationRequest.hsmIpAddress()));
        }
        if (createHsmConfigurationRequest.hsmPartitionName() != null) {
            request.addParameter("HsmPartitionName", StringUtils.fromString((String)createHsmConfigurationRequest.hsmPartitionName()));
        }
        if (createHsmConfigurationRequest.hsmPartitionPassword() != null) {
            request.addParameter("HsmPartitionPassword", StringUtils.fromString((String)createHsmConfigurationRequest.hsmPartitionPassword()));
        }
        if (createHsmConfigurationRequest.hsmServerPublicCertificate() != null) {
            request.addParameter("HsmServerPublicCertificate", StringUtils.fromString((String)createHsmConfigurationRequest.hsmServerPublicCertificate()));
        }
        if ((tagsList = createHsmConfigurationRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

