/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreTableFromClusterSnapshotRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, RestoreTableFromClusterSnapshotRequest> {
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String sourceDatabaseName;
    private final String sourceSchemaName;
    private final String sourceTableName;
    private final String targetDatabaseName;
    private final String targetSchemaName;
    private final String newTableName;

    private RestoreTableFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.newTableName = builder.newTableName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String sourceSchemaName() {
        return this.sourceSchemaName;
    }

    public String sourceTableName() {
        return this.sourceTableName;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public String targetSchemaName() {
        return this.targetSchemaName;
    }

    public String newTableName() {
        return this.newTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreTableFromClusterSnapshotRequest other = (RestoreTableFromClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.sourceDatabaseName(), other.sourceDatabaseName()) && Objects.equals(this.sourceSchemaName(), other.sourceSchemaName()) && Objects.equals(this.sourceTableName(), other.sourceTableName()) && Objects.equals(this.targetDatabaseName(), other.targetDatabaseName()) && Objects.equals(this.targetSchemaName(), other.targetSchemaName()) && Objects.equals(this.newTableName(), other.newTableName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.sourceDatabaseName() != null) {
            sb.append("SourceDatabaseName: ").append(this.sourceDatabaseName()).append(",");
        }
        if (this.sourceSchemaName() != null) {
            sb.append("SourceSchemaName: ").append(this.sourceSchemaName()).append(",");
        }
        if (this.sourceTableName() != null) {
            sb.append("SourceTableName: ").append(this.sourceTableName()).append(",");
        }
        if (this.targetDatabaseName() != null) {
            sb.append("TargetDatabaseName: ").append(this.targetDatabaseName()).append(",");
        }
        if (this.targetSchemaName() != null) {
            sb.append("TargetSchemaName: ").append(this.targetSchemaName()).append(",");
        }
        if (this.newTableName() != null) {
            sb.append("NewTableName: ").append(this.newTableName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "SourceDatabaseName": {
                return Optional.of(clazz.cast(this.sourceDatabaseName()));
            }
            case "SourceSchemaName": {
                return Optional.of(clazz.cast(this.sourceSchemaName()));
            }
            case "SourceTableName": {
                return Optional.of(clazz.cast(this.sourceTableName()));
            }
            case "TargetDatabaseName": {
                return Optional.of(clazz.cast(this.targetDatabaseName()));
            }
            case "TargetSchemaName": {
                return Optional.of(clazz.cast(this.targetSchemaName()));
            }
            case "NewTableName": {
                return Optional.of(clazz.cast(this.newTableName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String sourceDatabaseName;
        private String sourceSchemaName;
        private String sourceTableName;
        private String targetDatabaseName;
        private String targetSchemaName;
        private String newTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromClusterSnapshotRequest model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.sourceDatabaseName(model.sourceDatabaseName);
            this.sourceSchemaName(model.sourceSchemaName);
            this.sourceTableName(model.sourceTableName);
            this.targetDatabaseName(model.targetDatabaseName);
            this.targetSchemaName(model.targetSchemaName);
            this.newTableName(model.newTableName);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSourceDatabaseName() {
            return this.sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        public final String getSourceSchemaName() {
            return this.sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        public final String getTargetSchemaName() {
            return this.targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        public final String getNewTableName() {
            return this.newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromClusterSnapshotRequest build() {
            return new RestoreTableFromClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, RestoreTableFromClusterSnapshotRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder sourceDatabaseName(String var1);

        public Builder sourceSchemaName(String var1);

        public Builder sourceTableName(String var1);

        public Builder targetDatabaseName(String var1);

        public Builder targetSchemaName(String var1);

        public Builder newTableName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

