/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventCategoriesRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DescribeEventCategoriesRequest> {
    private final String sourceType;

    private DescribeEventCategoriesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceType = builder.sourceType;
    }

    public String sourceType() {
        return this.sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesRequest)) {
            return false;
        }
        DescribeEventCategoriesRequest other = (DescribeEventCategoriesRequest)((Object)obj);
        return Objects.equals(this.sourceType(), other.sourceType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesRequest model) {
            this.sourceType(model.sourceType);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventCategoriesRequest build() {
            return new DescribeEventCategoriesRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, DescribeEventCategoriesRequest> {
        public Builder sourceType(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

