/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteEventSubscriptionRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeleteEventSubscriptionRequest> {
    private final String subscriptionName;

    private DeleteEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEventSubscriptionRequest)) {
            return false;
        }
        DeleteEventSubscriptionRequest other = (DeleteEventSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionName(), other.subscriptionName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subscriptionName() != null) {
            sb.append("SubscriptionName: ").append(this.subscriptionName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionName": {
                return Optional.of(clazz.cast(this.subscriptionName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String subscriptionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEventSubscriptionRequest model) {
            this.subscriptionName(model.subscriptionName);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteEventSubscriptionRequest build() {
            return new DeleteEventSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, DeleteEventSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

