/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterSubnetGroupRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateClusterSubnetGroupRequest> {
    private final String clusterSubnetGroupName;
    private final String description;
    private final List<String> subnetIds;
    private final List<Tag> tags;

    private CreateClusterSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSubnetGroupRequest)) {
            return false;
        }
        CreateClusterSubnetGroupRequest other = (CreateClusterSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSubnetGroupName": {
                return Optional.of(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private String description;
        private List<String> subnetIds;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterSubnetGroupRequest model) {
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.description(model.description);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterSubnetGroupRequest build() {
            return new CreateClusterSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, CreateClusterSubnetGroupRequest> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder description(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

