/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;

public final class DescribeReservedNodesPaginator
implements SdkIterable<DescribeReservedNodesResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedNodesPaginator(RedshiftClient client, DescribeReservedNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodesResponseFetcher();
    }

    public Iterator<DescribeReservedNodesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedNode> reservedNodes() {
        Function<DescribeReservedNodesResponse, Iterator> getIterator = response -> response != null ? response.reservedNodes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedNodesResponseFetcher
    implements NextPageFetcher<DescribeReservedNodesResponse> {
        private DescribeReservedNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedNodesResponse nextPage(DescribeReservedNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesPaginator.this.client.describeReservedNodes(DescribeReservedNodesPaginator.this.firstRequest);
            }
            return DescribeReservedNodesPaginator.this.client.describeReservedNodes((DescribeReservedNodesRequest)((Object)DescribeReservedNodesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

