/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TaggedResource
implements ToCopyableBuilder<Builder, TaggedResource> {
    private final Tag tag;
    private final String resourceName;
    private final String resourceType;

    private TaggedResource(BuilderImpl builder) {
        this.tag = builder.tag;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
    }

    public Tag tag() {
        return this.tag;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tag());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaggedResource)) {
            return false;
        }
        TaggedResource other = (TaggedResource)obj;
        return Objects.equals(this.tag(), other.tag()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceType(), other.resourceType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tag() != null) {
            sb.append("Tag: ").append(this.tag()).append(",");
        }
        if (this.resourceName() != null) {
            sb.append("ResourceName: ").append(this.resourceName()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tag": {
                return Optional.of(clazz.cast(this.tag()));
            }
            case "ResourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Tag tag;
        private String resourceName;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TaggedResource model) {
            this.tag(model.tag);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
        }

        public final Tag.Builder getTag() {
            return this.tag != null ? this.tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public TaggedResource build() {
            return new TaggedResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TaggedResource> {
        public Builder tag(Tag var1);

        default public Builder tag(Consumer<Tag.Builder> tag) {
            return this.tag((Tag)((Tag.Builder)Tag.builder().apply(tag)).build());
        }

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);
    }
}

