/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.DbGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetClusterCredentialsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetClusterCredentialsRequest> {
    private final String dbUser;
    private final String dbName;
    private final String clusterIdentifier;
    private final Integer durationSeconds;
    private final Boolean autoCreate;
    private final List<String> dbGroups;

    private GetClusterCredentialsRequest(BuilderImpl builder) {
        this.dbUser = builder.dbUser;
        this.dbName = builder.dbName;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.durationSeconds = builder.durationSeconds;
        this.autoCreate = builder.autoCreate;
        this.dbGroups = builder.dbGroups;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String dbName() {
        return this.dbName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Integer durationSeconds() {
        return this.durationSeconds;
    }

    public Boolean autoCreate() {
        return this.autoCreate;
    }

    public List<String> dbGroups() {
        return this.dbGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsRequest)) {
            return false;
        }
        GetClusterCredentialsRequest other = (GetClusterCredentialsRequest)((Object)obj);
        return Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.autoCreate(), other.autoCreate()) && Objects.equals(this.dbGroups(), other.dbGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbUser() != null) {
            sb.append("DbUser: ").append(this.dbUser()).append(",");
        }
        if (this.dbName() != null) {
            sb.append("DbName: ").append(this.dbName()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.durationSeconds() != null) {
            sb.append("DurationSeconds: ").append(this.durationSeconds()).append(",");
        }
        if (this.autoCreate() != null) {
            sb.append("AutoCreate: ").append(this.autoCreate()).append(",");
        }
        if (this.dbGroups() != null) {
            sb.append("DbGroups: ").append(this.dbGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbUser": {
                return Optional.of(clazz.cast(this.dbUser()));
            }
            case "DbName": {
                return Optional.of(clazz.cast(this.dbName()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "DurationSeconds": {
                return Optional.of(clazz.cast(this.durationSeconds()));
            }
            case "AutoCreate": {
                return Optional.of(clazz.cast(this.autoCreate()));
            }
            case "DbGroups": {
                return Optional.of(clazz.cast(this.dbGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbUser;
        private String dbName;
        private String clusterIdentifier;
        private Integer durationSeconds;
        private Boolean autoCreate;
        private List<String> dbGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsRequest model) {
            this.dbUser(model.dbUser);
            this.dbName(model.dbName);
            this.clusterIdentifier(model.clusterIdentifier);
            this.durationSeconds(model.durationSeconds);
            this.autoCreate(model.autoCreate);
            this.dbGroups(model.dbGroups);
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        public final Boolean getAutoCreate() {
            return this.autoCreate;
        }

        @Override
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public final Collection<String> getDbGroups() {
            return this.dbGroups;
        }

        @Override
        public final Builder dbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbGroups(String ... dbGroups) {
            this.dbGroups(Arrays.asList(dbGroups));
            return this;
        }

        public final void setDbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
        }

        public GetClusterCredentialsRequest build() {
            return new GetClusterCredentialsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetClusterCredentialsRequest> {
        public Builder dbUser(String var1);

        public Builder dbName(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder autoCreate(Boolean var1);

        public Builder dbGroups(Collection<String> var1);

        public Builder dbGroups(String ... var1);
    }
}

