/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotCopyGrantsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSnapshotCopyGrantsRequest> {
    private final String snapshotCopyGrantName;
    private final Integer maxRecords;
    private final String marker;
    private final List<String> tagKeys;
    private final List<String> tagValues;

    private DescribeSnapshotCopyGrantsRequest(BuilderImpl builder) {
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
    }

    public String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyGrantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotCopyGrantsRequest)) {
            return false;
        }
        DescribeSnapshotCopyGrantsRequest other = (DescribeSnapshotCopyGrantsRequest)((Object)obj);
        return Objects.equals(this.snapshotCopyGrantName(), other.snapshotCopyGrantName()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.tagKeys(), other.tagKeys()) && Objects.equals(this.tagValues(), other.tagValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.snapshotCopyGrantName() != null) {
            sb.append("SnapshotCopyGrantName: ").append(this.snapshotCopyGrantName()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (this.tagValues() != null) {
            sb.append("TagValues: ").append(this.tagValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotCopyGrantName": {
                return Optional.of(clazz.cast(this.snapshotCopyGrantName()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "TagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
            case "TagValues": {
                return Optional.of(clazz.cast(this.tagValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotCopyGrantName;
        private Integer maxRecords;
        private String marker;
        private List<String> tagKeys;
        private List<String> tagValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotCopyGrantsRequest model) {
            this.snapshotCopyGrantName(model.snapshotCopyGrantName);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.tagKeys(model.tagKeys);
            this.tagValues(model.tagValues);
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        public final Collection<String> getTagValues() {
            return this.tagValues;
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        public DescribeSnapshotCopyGrantsRequest build() {
            return new DescribeSnapshotCopyGrantsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSnapshotCopyGrantsRequest> {
        public Builder snapshotCopyGrantName(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

