/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AuthorizeSnapshotAccessRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AuthorizeSnapshotAccessRequest> {
    private final String snapshotIdentifier;
    private final String snapshotClusterIdentifier;
    private final String accountWithRestoreAccess;

    private AuthorizeSnapshotAccessRequest(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.accountWithRestoreAccess = builder.accountWithRestoreAccess;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public String accountWithRestoreAccess() {
        return this.accountWithRestoreAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountWithRestoreAccess());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSnapshotAccessRequest)) {
            return false;
        }
        AuthorizeSnapshotAccessRequest other = (AuthorizeSnapshotAccessRequest)((Object)obj);
        return Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.snapshotClusterIdentifier(), other.snapshotClusterIdentifier()) && Objects.equals(this.accountWithRestoreAccess(), other.accountWithRestoreAccess());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.snapshotClusterIdentifier() != null) {
            sb.append("SnapshotClusterIdentifier: ").append(this.snapshotClusterIdentifier()).append(",");
        }
        if (this.accountWithRestoreAccess() != null) {
            sb.append("AccountWithRestoreAccess: ").append(this.accountWithRestoreAccess()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotClusterIdentifier": {
                return Optional.of(clazz.cast(this.snapshotClusterIdentifier()));
            }
            case "AccountWithRestoreAccess": {
                return Optional.of(clazz.cast(this.accountWithRestoreAccess()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String snapshotClusterIdentifier;
        private String accountWithRestoreAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSnapshotAccessRequest model) {
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            this.accountWithRestoreAccess(model.accountWithRestoreAccess);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final String getAccountWithRestoreAccess() {
            return this.accountWithRestoreAccess;
        }

        @Override
        public final Builder accountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
            return this;
        }

        public final void setAccountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
        }

        public AuthorizeSnapshotAccessRequest build() {
            return new AuthorizeSnapshotAccessRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthorizeSnapshotAccessRequest> {
        public Builder snapshotIdentifier(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder accountWithRestoreAccess(String var1);
    }
}

