/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess;
import software.amazon.awssdk.services.redshift.model.AccountsWithRestoreAccessListCopier;
import software.amazon.awssdk.services.redshift.model.RestorableNodeTypeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Snapshot
implements ToCopyableBuilder<Builder, Snapshot> {
    private final String snapshotIdentifier;
    private final String clusterIdentifier;
    private final Instant snapshotCreateTime;
    private final String status;
    private final Integer port;
    private final String availabilityZone;
    private final Instant clusterCreateTime;
    private final String masterUsername;
    private final String clusterVersion;
    private final String snapshotType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final String dbName;
    private final String vpcId;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final Boolean encryptedWithHSM;
    private final List<AccountWithRestoreAccess> accountsWithRestoreAccess;
    private final String ownerAccount;
    private final Double totalBackupSizeInMegaBytes;
    private final Double actualIncrementalBackupSizeInMegaBytes;
    private final Double backupProgressInMegaBytes;
    private final Double currentBackupRateInMegaBytesPerSecond;
    private final Long estimatedSecondsToCompletion;
    private final Long elapsedTimeInSeconds;
    private final String sourceRegion;
    private final List<Tag> tags;
    private final List<String> restorableNodeTypes;
    private final Boolean enhancedVpcRouting;

    private Snapshot(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.clusterVersion = builder.clusterVersion;
        this.snapshotType = builder.snapshotType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.dbName = builder.dbName;
        this.vpcId = builder.vpcId;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptedWithHSM = builder.encryptedWithHSM;
        this.accountsWithRestoreAccess = builder.accountsWithRestoreAccess;
        this.ownerAccount = builder.ownerAccount;
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
        this.actualIncrementalBackupSizeInMegaBytes = builder.actualIncrementalBackupSizeInMegaBytes;
        this.backupProgressInMegaBytes = builder.backupProgressInMegaBytes;
        this.currentBackupRateInMegaBytesPerSecond = builder.currentBackupRateInMegaBytesPerSecond;
        this.estimatedSecondsToCompletion = builder.estimatedSecondsToCompletion;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.sourceRegion = builder.sourceRegion;
        this.tags = builder.tags;
        this.restorableNodeTypes = builder.restorableNodeTypes;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public String dbName() {
        return this.dbName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean encryptedWithHSM() {
        return this.encryptedWithHSM;
    }

    public List<AccountWithRestoreAccess> accountsWithRestoreAccess() {
        return this.accountsWithRestoreAccess;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public Double totalBackupSizeInMegaBytes() {
        return this.totalBackupSizeInMegaBytes;
    }

    public Double actualIncrementalBackupSizeInMegaBytes() {
        return this.actualIncrementalBackupSizeInMegaBytes;
    }

    public Double backupProgressInMegaBytes() {
        return this.backupProgressInMegaBytes;
    }

    public Double currentBackupRateInMegaBytesPerSecond() {
        return this.currentBackupRateInMegaBytesPerSecond;
    }

    public Long estimatedSecondsToCompletion() {
        return this.estimatedSecondsToCompletion;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> restorableNodeTypes() {
        return this.restorableNodeTypes;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCreateTime() == null ? 0 : this.snapshotCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.clusterCreateTime() == null ? 0 : this.clusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.snapshotType() == null ? 0 : this.snapshotType().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.numberOfNodes() == null ? 0 : this.numberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.dbName() == null ? 0 : this.dbName().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.encrypted() == null ? 0 : this.encrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.encryptedWithHSM() == null ? 0 : this.encryptedWithHSM().hashCode());
        hashCode = 31 * hashCode + (this.accountsWithRestoreAccess() == null ? 0 : this.accountsWithRestoreAccess().hashCode());
        hashCode = 31 * hashCode + (this.ownerAccount() == null ? 0 : this.ownerAccount().hashCode());
        hashCode = 31 * hashCode + (this.totalBackupSizeInMegaBytes() == null ? 0 : this.totalBackupSizeInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.actualIncrementalBackupSizeInMegaBytes() == null ? 0 : this.actualIncrementalBackupSizeInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.backupProgressInMegaBytes() == null ? 0 : this.backupProgressInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.currentBackupRateInMegaBytesPerSecond() == null ? 0 : this.currentBackupRateInMegaBytesPerSecond().hashCode());
        hashCode = 31 * hashCode + (this.estimatedSecondsToCompletion() == null ? 0 : this.estimatedSecondsToCompletion().hashCode());
        hashCode = 31 * hashCode + (this.elapsedTimeInSeconds() == null ? 0 : this.elapsedTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.sourceRegion() == null ? 0 : this.sourceRegion().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.restorableNodeTypes() == null ? 0 : this.restorableNodeTypes().hashCode());
        hashCode = 31 * hashCode + (this.enhancedVpcRouting() == null ? 0 : this.enhancedVpcRouting().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.snapshotCreateTime() == null ^ this.snapshotCreateTime() == null) {
            return false;
        }
        if (other.snapshotCreateTime() != null && !other.snapshotCreateTime().equals(this.snapshotCreateTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.clusterCreateTime() == null ^ this.clusterCreateTime() == null) {
            return false;
        }
        if (other.clusterCreateTime() != null && !other.clusterCreateTime().equals(this.clusterCreateTime())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.snapshotType() == null ^ this.snapshotType() == null) {
            return false;
        }
        if (other.snapshotType() != null && !other.snapshotType().equals(this.snapshotType())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.numberOfNodes() == null ^ this.numberOfNodes() == null) {
            return false;
        }
        if (other.numberOfNodes() != null && !other.numberOfNodes().equals(this.numberOfNodes())) {
            return false;
        }
        if (other.dbName() == null ^ this.dbName() == null) {
            return false;
        }
        if (other.dbName() != null && !other.dbName().equals(this.dbName())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.encryptedWithHSM() == null ^ this.encryptedWithHSM() == null) {
            return false;
        }
        if (other.encryptedWithHSM() != null && !other.encryptedWithHSM().equals(this.encryptedWithHSM())) {
            return false;
        }
        if (other.accountsWithRestoreAccess() == null ^ this.accountsWithRestoreAccess() == null) {
            return false;
        }
        if (other.accountsWithRestoreAccess() != null && !other.accountsWithRestoreAccess().equals(this.accountsWithRestoreAccess())) {
            return false;
        }
        if (other.ownerAccount() == null ^ this.ownerAccount() == null) {
            return false;
        }
        if (other.ownerAccount() != null && !other.ownerAccount().equals(this.ownerAccount())) {
            return false;
        }
        if (other.totalBackupSizeInMegaBytes() == null ^ this.totalBackupSizeInMegaBytes() == null) {
            return false;
        }
        if (other.totalBackupSizeInMegaBytes() != null && !other.totalBackupSizeInMegaBytes().equals(this.totalBackupSizeInMegaBytes())) {
            return false;
        }
        if (other.actualIncrementalBackupSizeInMegaBytes() == null ^ this.actualIncrementalBackupSizeInMegaBytes() == null) {
            return false;
        }
        if (other.actualIncrementalBackupSizeInMegaBytes() != null && !other.actualIncrementalBackupSizeInMegaBytes().equals(this.actualIncrementalBackupSizeInMegaBytes())) {
            return false;
        }
        if (other.backupProgressInMegaBytes() == null ^ this.backupProgressInMegaBytes() == null) {
            return false;
        }
        if (other.backupProgressInMegaBytes() != null && !other.backupProgressInMegaBytes().equals(this.backupProgressInMegaBytes())) {
            return false;
        }
        if (other.currentBackupRateInMegaBytesPerSecond() == null ^ this.currentBackupRateInMegaBytesPerSecond() == null) {
            return false;
        }
        if (other.currentBackupRateInMegaBytesPerSecond() != null && !other.currentBackupRateInMegaBytesPerSecond().equals(this.currentBackupRateInMegaBytesPerSecond())) {
            return false;
        }
        if (other.estimatedSecondsToCompletion() == null ^ this.estimatedSecondsToCompletion() == null) {
            return false;
        }
        if (other.estimatedSecondsToCompletion() != null && !other.estimatedSecondsToCompletion().equals(this.estimatedSecondsToCompletion())) {
            return false;
        }
        if (other.elapsedTimeInSeconds() == null ^ this.elapsedTimeInSeconds() == null) {
            return false;
        }
        if (other.elapsedTimeInSeconds() != null && !other.elapsedTimeInSeconds().equals(this.elapsedTimeInSeconds())) {
            return false;
        }
        if (other.sourceRegion() == null ^ this.sourceRegion() == null) {
            return false;
        }
        if (other.sourceRegion() != null && !other.sourceRegion().equals(this.sourceRegion())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.restorableNodeTypes() == null ^ this.restorableNodeTypes() == null) {
            return false;
        }
        if (other.restorableNodeTypes() != null && !other.restorableNodeTypes().equals(this.restorableNodeTypes())) {
            return false;
        }
        if (other.enhancedVpcRouting() == null ^ this.enhancedVpcRouting() == null) {
            return false;
        }
        return other.enhancedVpcRouting() == null || other.enhancedVpcRouting().equals(this.enhancedVpcRouting());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.snapshotCreateTime() != null) {
            sb.append("SnapshotCreateTime: ").append(this.snapshotCreateTime()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.clusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.clusterCreateTime()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.snapshotType() != null) {
            sb.append("SnapshotType: ").append(this.snapshotType()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.numberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.numberOfNodes()).append(",");
        }
        if (this.dbName() != null) {
            sb.append("DBName: ").append(this.dbName()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.encryptedWithHSM() != null) {
            sb.append("EncryptedWithHSM: ").append(this.encryptedWithHSM()).append(",");
        }
        if (this.accountsWithRestoreAccess() != null) {
            sb.append("AccountsWithRestoreAccess: ").append(this.accountsWithRestoreAccess()).append(",");
        }
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.totalBackupSizeInMegaBytes() != null) {
            sb.append("TotalBackupSizeInMegaBytes: ").append(this.totalBackupSizeInMegaBytes()).append(",");
        }
        if (this.actualIncrementalBackupSizeInMegaBytes() != null) {
            sb.append("ActualIncrementalBackupSizeInMegaBytes: ").append(this.actualIncrementalBackupSizeInMegaBytes()).append(",");
        }
        if (this.backupProgressInMegaBytes() != null) {
            sb.append("BackupProgressInMegaBytes: ").append(this.backupProgressInMegaBytes()).append(",");
        }
        if (this.currentBackupRateInMegaBytesPerSecond() != null) {
            sb.append("CurrentBackupRateInMegaBytesPerSecond: ").append(this.currentBackupRateInMegaBytesPerSecond()).append(",");
        }
        if (this.estimatedSecondsToCompletion() != null) {
            sb.append("EstimatedSecondsToCompletion: ").append(this.estimatedSecondsToCompletion()).append(",");
        }
        if (this.elapsedTimeInSeconds() != null) {
            sb.append("ElapsedTimeInSeconds: ").append(this.elapsedTimeInSeconds()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.restorableNodeTypes() != null) {
            sb.append("RestorableNodeTypes: ").append(this.restorableNodeTypes()).append(",");
        }
        if (this.enhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.enhancedVpcRouting()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotCreateTime": {
                return Optional.of(clazz.cast(this.snapshotCreateTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.of(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "ClusterCreateTime": {
                return Optional.of(clazz.cast(this.clusterCreateTime()));
            }
            case "MasterUsername": {
                return Optional.of(clazz.cast(this.masterUsername()));
            }
            case "ClusterVersion": {
                return Optional.of(clazz.cast(this.clusterVersion()));
            }
            case "SnapshotType": {
                return Optional.of(clazz.cast(this.snapshotType()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.of(clazz.cast(this.numberOfNodes()));
            }
            case "DBName": {
                return Optional.of(clazz.cast(this.dbName()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "EncryptedWithHSM": {
                return Optional.of(clazz.cast(this.encryptedWithHSM()));
            }
            case "AccountsWithRestoreAccess": {
                return Optional.of(clazz.cast(this.accountsWithRestoreAccess()));
            }
            case "OwnerAccount": {
                return Optional.of(clazz.cast(this.ownerAccount()));
            }
            case "TotalBackupSizeInMegaBytes": {
                return Optional.of(clazz.cast(this.totalBackupSizeInMegaBytes()));
            }
            case "ActualIncrementalBackupSizeInMegaBytes": {
                return Optional.of(clazz.cast(this.actualIncrementalBackupSizeInMegaBytes()));
            }
            case "BackupProgressInMegaBytes": {
                return Optional.of(clazz.cast(this.backupProgressInMegaBytes()));
            }
            case "CurrentBackupRateInMegaBytesPerSecond": {
                return Optional.of(clazz.cast(this.currentBackupRateInMegaBytesPerSecond()));
            }
            case "EstimatedSecondsToCompletion": {
                return Optional.of(clazz.cast(this.estimatedSecondsToCompletion()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.of(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "SourceRegion": {
                return Optional.of(clazz.cast(this.sourceRegion()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "RestorableNodeTypes": {
                return Optional.of(clazz.cast(this.restorableNodeTypes()));
            }
            case "EnhancedVpcRouting": {
                return Optional.of(clazz.cast(this.enhancedVpcRouting()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String clusterIdentifier;
        private Instant snapshotCreateTime;
        private String status;
        private Integer port;
        private String availabilityZone;
        private Instant clusterCreateTime;
        private String masterUsername;
        private String clusterVersion;
        private String snapshotType;
        private String nodeType;
        private Integer numberOfNodes;
        private String dbName;
        private String vpcId;
        private Boolean encrypted;
        private String kmsKeyId;
        private Boolean encryptedWithHSM;
        private List<AccountWithRestoreAccess> accountsWithRestoreAccess;
        private String ownerAccount;
        private Double totalBackupSizeInMegaBytes;
        private Double actualIncrementalBackupSizeInMegaBytes;
        private Double backupProgressInMegaBytes;
        private Double currentBackupRateInMegaBytesPerSecond;
        private Long estimatedSecondsToCompletion;
        private Long elapsedTimeInSeconds;
        private String sourceRegion;
        private List<Tag> tags;
        private List<String> restorableNodeTypes;
        private Boolean enhancedVpcRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.status(model.status);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.clusterCreateTime(model.clusterCreateTime);
            this.masterUsername(model.masterUsername);
            this.clusterVersion(model.clusterVersion);
            this.snapshotType(model.snapshotType);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.dbName(model.dbName);
            this.vpcId(model.vpcId);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.encryptedWithHSM(model.encryptedWithHSM);
            this.accountsWithRestoreAccess(model.accountsWithRestoreAccess);
            this.ownerAccount(model.ownerAccount);
            this.totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
            this.actualIncrementalBackupSizeInMegaBytes(model.actualIncrementalBackupSizeInMegaBytes);
            this.backupProgressInMegaBytes(model.backupProgressInMegaBytes);
            this.currentBackupRateInMegaBytesPerSecond(model.currentBackupRateInMegaBytesPerSecond);
            this.estimatedSecondsToCompletion(model.estimatedSecondsToCompletion);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.sourceRegion(model.sourceRegion);
            this.tags(model.tags);
            this.restorableNodeTypes(model.restorableNodeTypes);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEncryptedWithHSM() {
            return this.encryptedWithHSM;
        }

        @Override
        public final Builder encryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
            return this;
        }

        public final void setEncryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
        }

        public final Collection<AccountWithRestoreAccess.Builder> getAccountsWithRestoreAccess() {
            return this.accountsWithRestoreAccess != null ? (Collection)this.accountsWithRestoreAccess.stream().map(AccountWithRestoreAccess::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copy(accountsWithRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(AccountWithRestoreAccess ... accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess(Arrays.asList(accountsWithRestoreAccess));
            return this;
        }

        public final void setAccountsWithRestoreAccess(Collection<AccountWithRestoreAccess.BuilderImpl> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copyFromBuilder(accountsWithRestoreAccess);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return this.totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        public final Double getActualIncrementalBackupSizeInMegaBytes() {
            return this.actualIncrementalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
            return this;
        }

        public final void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        }

        public final Double getBackupProgressInMegaBytes() {
            return this.backupProgressInMegaBytes;
        }

        @Override
        public final Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
            return this;
        }

        public final void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        }

        public final Double getCurrentBackupRateInMegaBytesPerSecond() {
            return this.currentBackupRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        }

        public final Long getEstimatedSecondsToCompletion() {
            return this.estimatedSecondsToCompletion;
        }

        @Override
        public final Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
            return this;
        }

        public final void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getRestorableNodeTypes() {
            return this.restorableNodeTypes;
        }

        @Override
        public final Builder restorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableNodeTypes(String ... restorableNodeTypes) {
            this.restorableNodeTypes(Arrays.asList(restorableNodeTypes));
            return this;
        }

        public final void setRestorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Snapshot> {
        public Builder snapshotIdentifier(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder clusterVersion(String var1);

        public Builder snapshotType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder dbName(String var1);

        public Builder vpcId(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder encryptedWithHSM(Boolean var1);

        public Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> var1);

        public Builder accountsWithRestoreAccess(AccountWithRestoreAccess ... var1);

        public Builder ownerAccount(String var1);

        public Builder totalBackupSizeInMegaBytes(Double var1);

        public Builder actualIncrementalBackupSizeInMegaBytes(Double var1);

        public Builder backupProgressInMegaBytes(Double var1);

        public Builder currentBackupRateInMegaBytesPerSecond(Double var1);

        public Builder estimatedSecondsToCompletion(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder sourceRegion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder restorableNodeTypes(Collection<String> var1);

        public Builder restorableNodeTypes(String ... var1);

        public Builder enhancedVpcRouting(Boolean var1);
    }
}

