/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.IamRoleArnListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyClusterIamRolesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
    private final String clusterIdentifier;
    private final List<String> addIamRoles;
    private final List<String> removeIamRoles;

    private ModifyClusterIamRolesRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.addIamRoles = builder.addIamRoles;
        this.removeIamRoles = builder.removeIamRoles;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public List<String> addIamRoles() {
        return this.addIamRoles;
    }

    public List<String> removeIamRoles() {
        return this.removeIamRoles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.addIamRoles() == null ? 0 : this.addIamRoles().hashCode());
        hashCode = 31 * hashCode + (this.removeIamRoles() == null ? 0 : this.removeIamRoles().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterIamRolesRequest)) {
            return false;
        }
        ModifyClusterIamRolesRequest other = (ModifyClusterIamRolesRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.addIamRoles() == null ^ this.addIamRoles() == null) {
            return false;
        }
        if (other.addIamRoles() != null && !other.addIamRoles().equals(this.addIamRoles())) {
            return false;
        }
        if (other.removeIamRoles() == null ^ this.removeIamRoles() == null) {
            return false;
        }
        return other.removeIamRoles() == null || other.removeIamRoles().equals(this.removeIamRoles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.addIamRoles() != null) {
            sb.append("AddIamRoles: ").append(this.addIamRoles()).append(",");
        }
        if (this.removeIamRoles() != null) {
            sb.append("RemoveIamRoles: ").append(this.removeIamRoles()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "AddIamRoles": {
                return Optional.of(clazz.cast(this.addIamRoles()));
            }
            case "RemoveIamRoles": {
                return Optional.of(clazz.cast(this.removeIamRoles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private List<String> addIamRoles;
        private List<String> removeIamRoles;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterIamRolesRequest model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.addIamRoles(model.addIamRoles);
            this.removeIamRoles(model.removeIamRoles);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Collection<String> getAddIamRoles() {
            return this.addIamRoles;
        }

        @Override
        public final Builder addIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addIamRoles(String ... addIamRoles) {
            this.addIamRoles(Arrays.asList(addIamRoles));
            return this;
        }

        public final void setAddIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
        }

        public final Collection<String> getRemoveIamRoles() {
            return this.removeIamRoles;
        }

        @Override
        public final Builder removeIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIamRoles(String ... removeIamRoles) {
            this.removeIamRoles(Arrays.asList(removeIamRoles));
            return this;
        }

        public final void setRemoveIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
        }

        public ModifyClusterIamRolesRequest build() {
            return new ModifyClusterIamRolesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder addIamRoles(Collection<String> var1);

        public Builder addIamRoles(String ... var1);

        public Builder removeIamRoles(Collection<String> var1);

        public Builder removeIamRoles(String ... var1);
    }
}

