/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDefaultClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeDefaultClusterParametersRequest>, DescribeDefaultClusterParametersRequest> {
    public Request<DescribeDefaultClusterParametersRequest> marshall(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        if (describeDefaultClusterParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDefaultClusterParametersRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeDefaultClusterParameters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDefaultClusterParametersRequest.parameterGroupFamily() != null) {
            request.addParameter("ParameterGroupFamily", StringUtils.fromString((String)describeDefaultClusterParametersRequest.parameterGroupFamily()));
        }
        if (describeDefaultClusterParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDefaultClusterParametersRequest.maxRecords()));
        }
        if (describeDefaultClusterParametersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDefaultClusterParametersRequest.marker()));
        }
        return request;
    }
}

