/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSecurityGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
    private final String marker;
    private final List<ClusterSecurityGroup> clusterSecurityGroups;

    private DescribeClusterSecurityGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterSecurityGroup> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.clusterSecurityGroups() == null ? 0 : this.clusterSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSecurityGroupsResponse)) {
            return false;
        }
        DescribeClusterSecurityGroupsResponse other = (DescribeClusterSecurityGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.clusterSecurityGroups() == null ^ this.clusterSecurityGroups() == null) {
            return false;
        }
        return other.clusterSecurityGroups() == null || other.clusterSecurityGroups().equals(this.clusterSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.clusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.clusterSecurityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterSecurityGroup> clusterSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSecurityGroupsResponse model) {
            this.setMarker(model.marker);
            this.setClusterSecurityGroups(model.clusterSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterSecurityGroup> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroup ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroup> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copy(clusterSecurityGroups);
        }

        public DescribeClusterSecurityGroupsResponse build() {
            return new DescribeClusterSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> var1);

        public Builder clusterSecurityGroups(ClusterSecurityGroup ... var1);
    }
}

