/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.redshift.model.SourceIdsListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateEventSubscriptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateEventSubscriptionRequest> {
    private final String subscriptionName;
    private final String snsTopicArn;
    private final String sourceType;
    private final List<String> sourceIds;
    private final List<String> eventCategories;
    private final String severity;
    private final Boolean enabled;
    private final List<Tag> tags;

    private CreateEventSubscriptionRequest(BuilderImpl builder) {
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.sourceIds = builder.sourceIds;
        this.eventCategories = builder.eventCategories;
        this.severity = builder.severity;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> sourceIds() {
        return this.sourceIds;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public String severity() {
        return this.severity;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionName() == null ? 0 : this.subscriptionName().hashCode());
        hashCode = 31 * hashCode + (this.snsTopicArn() == null ? 0 : this.snsTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.sourceIds() == null ? 0 : this.sourceIds().hashCode());
        hashCode = 31 * hashCode + (this.eventCategories() == null ? 0 : this.eventCategories().hashCode());
        hashCode = 31 * hashCode + (this.severity() == null ? 0 : this.severity().hashCode());
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSubscriptionRequest)) {
            return false;
        }
        CreateEventSubscriptionRequest other = (CreateEventSubscriptionRequest)((Object)obj);
        if (other.subscriptionName() == null ^ this.subscriptionName() == null) {
            return false;
        }
        if (other.subscriptionName() != null && !other.subscriptionName().equals(this.subscriptionName())) {
            return false;
        }
        if (other.snsTopicArn() == null ^ this.snsTopicArn() == null) {
            return false;
        }
        if (other.snsTopicArn() != null && !other.snsTopicArn().equals(this.snsTopicArn())) {
            return false;
        }
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.sourceIds() == null ^ this.sourceIds() == null) {
            return false;
        }
        if (other.sourceIds() != null && !other.sourceIds().equals(this.sourceIds())) {
            return false;
        }
        if (other.eventCategories() == null ^ this.eventCategories() == null) {
            return false;
        }
        if (other.eventCategories() != null && !other.eventCategories().equals(this.eventCategories())) {
            return false;
        }
        if (other.severity() == null ^ this.severity() == null) {
            return false;
        }
        if (other.severity() != null && !other.severity().equals(this.severity())) {
            return false;
        }
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptionName() != null) {
            sb.append("SubscriptionName: ").append(this.subscriptionName()).append(",");
        }
        if (this.snsTopicArn() != null) {
            sb.append("SnsTopicArn: ").append(this.snsTopicArn()).append(",");
        }
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.sourceIds() != null) {
            sb.append("SourceIds: ").append(this.sourceIds()).append(",");
        }
        if (this.eventCategories() != null) {
            sb.append("EventCategories: ").append(this.eventCategories()).append(",");
        }
        if (this.severity() != null) {
            sb.append("Severity: ").append(this.severity()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String subscriptionName;
        private String snsTopicArn;
        private String sourceType;
        private List<String> sourceIds;
        private List<String> eventCategories;
        private String severity;
        private Boolean enabled;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSubscriptionRequest model) {
            this.setSubscriptionName(model.subscriptionName);
            this.setSnsTopicArn(model.snsTopicArn);
            this.setSourceType(model.sourceType);
            this.setSourceIds(model.sourceIds);
            this.setEventCategories(model.eventCategories);
            this.setSeverity(model.severity);
            this.setEnabled(model.enabled);
            this.setTags(model.tags);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getSourceIds() {
            return this.sourceIds;
        }

        @Override
        public final Builder sourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIds(String ... sourceIds) {
            this.sourceIds(Arrays.asList(sourceIds));
            return this;
        }

        public final void setSourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public CreateEventSubscriptionRequest build() {
            return new CreateEventSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateEventSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder snsTopicArn(String var1);

        public Builder sourceType(String var1);

        public Builder sourceIds(Collection<String> var1);

        public Builder sourceIds(String ... var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder severity(String var1);

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

