/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyClusterIamRolesRequestMarshaller
implements Marshaller<Request<ModifyClusterIamRolesRequest>, ModifyClusterIamRolesRequest> {
    public Request<ModifyClusterIamRolesRequest> marshall(ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) {
        List<String> removeIamRolesList;
        List<String> addIamRolesList;
        if (modifyClusterIamRolesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyClusterIamRolesRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyClusterIamRoles");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterIamRolesRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)modifyClusterIamRolesRequest.clusterIdentifier()));
        }
        if ((addIamRolesList = modifyClusterIamRolesRequest.addIamRoles()) != null) {
            if (!addIamRolesList.isEmpty()) {
                int addIamRolesListIndex = 1;
                for (String addIamRolesListValue : addIamRolesList) {
                    if (addIamRolesListValue != null) {
                        request.addParameter("AddIamRoles.IamRoleArn." + addIamRolesListIndex, StringUtils.fromString((String)addIamRolesListValue));
                    }
                    ++addIamRolesListIndex;
                }
            } else {
                request.addParameter("AddIamRoles", "");
            }
        }
        if ((removeIamRolesList = modifyClusterIamRolesRequest.removeIamRoles()) != null) {
            if (!removeIamRolesList.isEmpty()) {
                int removeIamRolesListIndex = 1;
                for (String removeIamRolesListValue : removeIamRolesList) {
                    if (removeIamRolesListValue != null) {
                        request.addParameter("RemoveIamRoles.IamRoleArn." + removeIamRolesListIndex, StringUtils.fromString((String)removeIamRolesListValue));
                    }
                    ++removeIamRolesListIndex;
                }
            } else {
                request.addParameter("RemoveIamRoles", "");
            }
        }
        return request;
    }
}

