/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeClusterVersionsRequestMarshaller
implements Marshaller<Request<DescribeClusterVersionsRequest>, DescribeClusterVersionsRequest> {
    public Request<DescribeClusterVersionsRequest> marshall(DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        if (describeClusterVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterVersionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterVersions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterVersionsRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)describeClusterVersionsRequest.clusterVersion()));
        }
        if (describeClusterVersionsRequest.clusterParameterGroupFamily() != null) {
            request.addParameter("ClusterParameterGroupFamily", StringUtils.fromString((String)describeClusterVersionsRequest.clusterParameterGroupFamily()));
        }
        if (describeClusterVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterVersionsRequest.maxRecords()));
        }
        if (describeClusterVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterVersionsRequest.marker()));
        }
        return request;
    }
}

