/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteClusterSnapshotRequestMarshaller
implements Marshaller<Request<DeleteClusterSnapshotRequest>, DeleteClusterSnapshotRequest> {
    public Request<DeleteClusterSnapshotRequest> marshall(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        if (deleteClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "DeleteClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteClusterSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)deleteClusterSnapshotRequest.snapshotIdentifier()));
        }
        if (deleteClusterSnapshotRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)deleteClusterSnapshotRequest.snapshotClusterIdentifier()));
        }
        return request;
    }
}

