/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CreateClusterParameterGroupRequest>, CreateClusterParameterGroupRequest> {
    public Request<CreateClusterParameterGroupRequest> marshall(CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        List<Tag> tagsList;
        if (createClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createClusterParameterGroupRequest, "RedshiftClient");
        request.addParameter("Action", "CreateClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterParameterGroupRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)createClusterParameterGroupRequest.parameterGroupName()));
        }
        if (createClusterParameterGroupRequest.parameterGroupFamily() != null) {
            request.addParameter("ParameterGroupFamily", StringUtils.fromString((String)createClusterParameterGroupRequest.parameterGroupFamily()));
        }
        if (createClusterParameterGroupRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createClusterParameterGroupRequest.description()));
        }
        if ((tagsList = createClusterParameterGroupRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

