/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.redshift.model.EventInfoMap;
import software.amazon.awssdk.services.redshift.model.EventInfoMapListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventCategoriesMap
implements ToCopyableBuilder<Builder, EventCategoriesMap> {
    private final String sourceType;
    private final List<EventInfoMap> events;

    private EventCategoriesMap(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.events = builder.events;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<EventInfoMap> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap)obj;
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        return other.events() == null || other.events().equals(this.events());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<EventInfoMap> events;

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoriesMap model) {
            this.setSourceType(model.sourceType);
            this.setEvents(model.events);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<EventInfoMap> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<EventInfoMap> events) {
            this.events = EventInfoMapListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(EventInfoMap ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<EventInfoMap> events) {
            this.events = EventInfoMapListCopier.copy(events);
        }

        public EventCategoriesMap build() {
            return new EventCategoriesMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventCategoriesMap> {
        public Builder sourceType(String var1);

        public Builder events(Collection<EventInfoMap> var1);

        public Builder events(EventInfoMap ... var1);
    }
}

