/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeOrderableClusterOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableClusterOptionsRequest>, DescribeOrderableClusterOptionsRequest> {
    public Request<DescribeOrderableClusterOptionsRequest> marshall(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        if (describeOrderableClusterOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeOrderableClusterOptionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeOrderableClusterOptions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableClusterOptionsRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)describeOrderableClusterOptionsRequest.clusterVersion()));
        }
        if (describeOrderableClusterOptionsRequest.nodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)describeOrderableClusterOptionsRequest.nodeType()));
        }
        if (describeOrderableClusterOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOrderableClusterOptionsRequest.maxRecords()));
        }
        if (describeOrderableClusterOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOrderableClusterOptionsRequest.marker()));
        }
        return request;
    }
}

