/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;

public class ClusterVersionUnmarshaller
implements Unmarshaller<ClusterVersion, StaxUnmarshallerContext> {
    private static ClusterVersionUnmarshaller INSTANCE;

    public ClusterVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ClusterVersion.Builder clusterVersion = ClusterVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ClusterVersion", targetDepth)) {
                    clusterVersion.clusterVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterParameterGroupFamily", targetDepth)) {
                    clusterVersion.clusterParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Description", targetDepth)) continue;
                clusterVersion.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ClusterVersion)clusterVersion.build();
    }

    public static ClusterVersionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClusterVersionUnmarshaller();
        }
        return INSTANCE;
    }
}

