/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HsmStatus
implements ToCopyableBuilder<Builder, HsmStatus> {
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String status;

    private HsmStatus(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.status = builder.status;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hsmClientCertificateIdentifier() == null ? 0 : this.hsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.hsmConfigurationIdentifier() == null ? 0 : this.hsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmStatus)) {
            return false;
        }
        HsmStatus other = (HsmStatus)obj;
        if (other.hsmClientCertificateIdentifier() == null ^ this.hsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.hsmClientCertificateIdentifier() != null && !other.hsmClientCertificateIdentifier().equals(this.hsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() == null ^ this.hsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() != null && !other.hsmConfigurationIdentifier().equals(this.hsmConfigurationIdentifier())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: ").append(this.hsmClientCertificateIdentifier()).append(",");
        }
        if (this.hsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: ").append(this.hsmConfigurationIdentifier()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HsmStatus model) {
            this.setHsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.setHsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.setStatus(model.status);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public HsmStatus build() {
            return new HsmStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HsmStatus> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder status(String var1);
    }
}

