/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.redshift.model.SourceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements ToCopyableBuilder<Builder, Event> {
    private final String sourceIdentifier;
    private final String sourceType;
    private final String message;
    private final List<String> eventCategories;
    private final String severity;
    private final Instant dateValue;
    private final String eventId;

    private Event(BuilderImpl builder) {
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceType = builder.sourceType;
        this.message = builder.message;
        this.eventCategories = builder.eventCategories;
        this.severity = builder.severity;
        this.dateValue = builder.dateValue;
        this.eventId = builder.eventId;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String message() {
        return this.message;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public String severity() {
        return this.severity;
    }

    public Instant date() {
        return this.dateValue;
    }

    public String eventId() {
        return this.eventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceIdentifier() == null ? 0 : this.sourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.eventCategories() == null ? 0 : this.eventCategories().hashCode());
        hashCode = 31 * hashCode + (this.severity() == null ? 0 : this.severity().hashCode());
        hashCode = 31 * hashCode + (this.date() == null ? 0 : this.date().hashCode());
        hashCode = 31 * hashCode + (this.eventId() == null ? 0 : this.eventId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.sourceIdentifier() == null ^ this.sourceIdentifier() == null) {
            return false;
        }
        if (other.sourceIdentifier() != null && !other.sourceIdentifier().equals(this.sourceIdentifier())) {
            return false;
        }
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.eventCategories() == null ^ this.eventCategories() == null) {
            return false;
        }
        if (other.eventCategories() != null && !other.eventCategories().equals(this.eventCategories())) {
            return false;
        }
        if (other.severity() == null ^ this.severity() == null) {
            return false;
        }
        if (other.severity() != null && !other.severity().equals(this.severity())) {
            return false;
        }
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        return other.eventId() == null || other.eventId().equals(this.eventId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.sourceIdentifier()).append(",");
        }
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.eventCategories() != null) {
            sb.append("EventCategories: ").append(this.eventCategories()).append(",");
        }
        if (this.severity() != null) {
            sb.append("Severity: ").append(this.severity()).append(",");
        }
        if (this.date() != null) {
            sb.append("Date: ").append(this.date()).append(",");
        }
        if (this.eventId() != null) {
            sb.append("EventId: ").append(this.eventId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceIdentifier;
        private String sourceType;
        private String message;
        private List<String> eventCategories;
        private String severity;
        private Instant dateValue;
        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.setSourceIdentifier(model.sourceIdentifier);
            this.setSourceType(model.sourceType);
            this.setMessage(model.message);
            this.setEventCategories(model.eventCategories);
            this.setSeverity(model.severity);
            this.setDate(model.dateValue);
            this.setEventId(model.eventId);
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final void setSourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @SafeVarargs
        public final void setEventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Instant getDate() {
            return this.dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder sourceIdentifier(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder message(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder severity(String var1);

        public Builder date(Instant var1);

        public Builder eventId(String var1);
    }
}

