/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ReservedNode;
import software.amazon.awssdk.services.redshift.model.ReservedNodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedNodesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedNodesResponse> {
    private final String marker;
    private final List<ReservedNode> reservedNodes;

    private DescribeReservedNodesResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.reservedNodes = builder.reservedNodes;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedNode> reservedNodes() {
        return this.reservedNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.reservedNodes() == null ? 0 : this.reservedNodes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesResponse)) {
            return false;
        }
        DescribeReservedNodesResponse other = (DescribeReservedNodesResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.reservedNodes() == null ^ this.reservedNodes() == null) {
            return false;
        }
        return other.reservedNodes() == null || other.reservedNodes().equals(this.reservedNodes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedNodes() != null) {
            sb.append("ReservedNodes: ").append(this.reservedNodes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedNode> reservedNodes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesResponse model) {
            this.setMarker(model.marker);
            this.setReservedNodes(model.reservedNodes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNode> getReservedNodes() {
            return this.reservedNodes;
        }

        @Override
        public final Builder reservedNodes(Collection<ReservedNode> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copy(reservedNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(ReservedNode ... reservedNodes) {
            this.reservedNodes(Arrays.asList(reservedNodes));
            return this;
        }

        public final void setReservedNodes(Collection<ReservedNode> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copy(reservedNodes);
        }

        @SafeVarargs
        public final void setReservedNodes(ReservedNode ... reservedNodes) {
            this.reservedNodes(Arrays.asList(reservedNodes));
        }

        public DescribeReservedNodesResponse build() {
            return new DescribeReservedNodesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedNodesResponse> {
        public Builder marker(String var1);

        public Builder reservedNodes(Collection<ReservedNode> var1);

        public Builder reservedNodes(ReservedNode ... var1);
    }
}

