/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedNodesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedNodesRequest> {
    private final String reservedNodeId;
    private final Integer maxRecords;
    private final String marker;

    private DescribeReservedNodesRequest(BuilderImpl builder) {
        this.reservedNodeId = builder.reservedNodeId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String reservedNodeId() {
        return this.reservedNodeId;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedNodeId() == null ? 0 : this.reservedNodeId().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesRequest)) {
            return false;
        }
        DescribeReservedNodesRequest other = (DescribeReservedNodesRequest)((Object)obj);
        if (other.reservedNodeId() == null ^ this.reservedNodeId() == null) {
            return false;
        }
        if (other.reservedNodeId() != null && !other.reservedNodeId().equals(this.reservedNodeId())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedNodeId() != null) {
            sb.append("ReservedNodeId: ").append(this.reservedNodeId()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String reservedNodeId;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesRequest model) {
            this.setReservedNodeId(model.reservedNodeId);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
        }

        public final String getReservedNodeId() {
            return this.reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeReservedNodesRequest build() {
            return new DescribeReservedNodesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedNodesRequest> {
        public Builder reservedNodeId(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

