/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNameListCopier;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyClusterRequest> {
    private final String clusterIdentifier;
    private final String clusterType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final List<String> clusterSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String masterUserPassword;
    private final String clusterParameterGroupName;
    private final Integer automatedSnapshotRetentionPeriod;
    private final String preferredMaintenanceWindow;
    private final String clusterVersion;
    private final Boolean allowVersionUpgrade;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String newClusterIdentifier;
    private final Boolean publiclyAccessible;
    private final String elasticIp;
    private final Boolean enhancedVpcRouting;

    private ModifyClusterRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.masterUserPassword = builder.masterUserPassword;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.newClusterIdentifier = builder.newClusterIdentifier;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.elasticIp = builder.elasticIp;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public List<String> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String clusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String newClusterIdentifier() {
        return this.newClusterIdentifier;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.clusterType() == null ? 0 : this.clusterType().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.numberOfNodes() == null ? 0 : this.numberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.clusterSecurityGroups() == null ? 0 : this.clusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupIds() == null ? 0 : this.vpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.masterUserPassword() == null ? 0 : this.masterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.clusterParameterGroupName() == null ? 0 : this.clusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.automatedSnapshotRetentionPeriod() == null ? 0 : this.automatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.allowVersionUpgrade() == null ? 0 : this.allowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.hsmClientCertificateIdentifier() == null ? 0 : this.hsmClientCertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.hsmConfigurationIdentifier() == null ? 0 : this.hsmConfigurationIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.newClusterIdentifier() == null ? 0 : this.newClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.elasticIp() == null ? 0 : this.elasticIp().hashCode());
        hashCode = 31 * hashCode + (this.enhancedVpcRouting() == null ? 0 : this.enhancedVpcRouting().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.clusterType() == null ^ this.clusterType() == null) {
            return false;
        }
        if (other.clusterType() != null && !other.clusterType().equals(this.clusterType())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.numberOfNodes() == null ^ this.numberOfNodes() == null) {
            return false;
        }
        if (other.numberOfNodes() != null && !other.numberOfNodes().equals(this.numberOfNodes())) {
            return false;
        }
        if (other.clusterSecurityGroups() == null ^ this.clusterSecurityGroups() == null) {
            return false;
        }
        if (other.clusterSecurityGroups() != null && !other.clusterSecurityGroups().equals(this.clusterSecurityGroups())) {
            return false;
        }
        if (other.vpcSecurityGroupIds() == null ^ this.vpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.vpcSecurityGroupIds() != null && !other.vpcSecurityGroupIds().equals(this.vpcSecurityGroupIds())) {
            return false;
        }
        if (other.masterUserPassword() == null ^ this.masterUserPassword() == null) {
            return false;
        }
        if (other.masterUserPassword() != null && !other.masterUserPassword().equals(this.masterUserPassword())) {
            return false;
        }
        if (other.clusterParameterGroupName() == null ^ this.clusterParameterGroupName() == null) {
            return false;
        }
        if (other.clusterParameterGroupName() != null && !other.clusterParameterGroupName().equals(this.clusterParameterGroupName())) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() == null ^ this.automatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.automatedSnapshotRetentionPeriod() != null && !other.automatedSnapshotRetentionPeriod().equals(this.automatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.allowVersionUpgrade() == null ^ this.allowVersionUpgrade() == null) {
            return false;
        }
        if (other.allowVersionUpgrade() != null && !other.allowVersionUpgrade().equals(this.allowVersionUpgrade())) {
            return false;
        }
        if (other.hsmClientCertificateIdentifier() == null ^ this.hsmClientCertificateIdentifier() == null) {
            return false;
        }
        if (other.hsmClientCertificateIdentifier() != null && !other.hsmClientCertificateIdentifier().equals(this.hsmClientCertificateIdentifier())) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() == null ^ this.hsmConfigurationIdentifier() == null) {
            return false;
        }
        if (other.hsmConfigurationIdentifier() != null && !other.hsmConfigurationIdentifier().equals(this.hsmConfigurationIdentifier())) {
            return false;
        }
        if (other.newClusterIdentifier() == null ^ this.newClusterIdentifier() == null) {
            return false;
        }
        if (other.newClusterIdentifier() != null && !other.newClusterIdentifier().equals(this.newClusterIdentifier())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.elasticIp() == null ^ this.elasticIp() == null) {
            return false;
        }
        if (other.elasticIp() != null && !other.elasticIp().equals(this.elasticIp())) {
            return false;
        }
        if (other.enhancedVpcRouting() == null ^ this.enhancedVpcRouting() == null) {
            return false;
        }
        return other.enhancedVpcRouting() == null || other.enhancedVpcRouting().equals(this.enhancedVpcRouting());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.clusterType() != null) {
            sb.append("ClusterType: ").append(this.clusterType()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.numberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.numberOfNodes()).append(",");
        }
        if (this.clusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.clusterSecurityGroups()).append(",");
        }
        if (this.vpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.vpcSecurityGroupIds()).append(",");
        }
        if (this.masterUserPassword() != null) {
            sb.append("MasterUserPassword: ").append(this.masterUserPassword()).append(",");
        }
        if (this.clusterParameterGroupName() != null) {
            sb.append("ClusterParameterGroupName: ").append(this.clusterParameterGroupName()).append(",");
        }
        if (this.automatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: ").append(this.automatedSnapshotRetentionPeriod()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.allowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: ").append(this.allowVersionUpgrade()).append(",");
        }
        if (this.hsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: ").append(this.hsmClientCertificateIdentifier()).append(",");
        }
        if (this.hsmConfigurationIdentifier() != null) {
            sb.append("HsmConfigurationIdentifier: ").append(this.hsmConfigurationIdentifier()).append(",");
        }
        if (this.newClusterIdentifier() != null) {
            sb.append("NewClusterIdentifier: ").append(this.newClusterIdentifier()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.elasticIp() != null) {
            sb.append("ElasticIp: ").append(this.elasticIp()).append(",");
        }
        if (this.enhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.enhancedVpcRouting()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String clusterType;
        private String nodeType;
        private Integer numberOfNodes;
        private List<String> clusterSecurityGroups;
        private List<String> vpcSecurityGroupIds;
        private String masterUserPassword;
        private String clusterParameterGroupName;
        private Integer automatedSnapshotRetentionPeriod;
        private String preferredMaintenanceWindow;
        private String clusterVersion;
        private Boolean allowVersionUpgrade;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String newClusterIdentifier;
        private Boolean publiclyAccessible;
        private String elasticIp;
        private Boolean enhancedVpcRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterRequest model) {
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setClusterType(model.clusterType);
            this.setNodeType(model.nodeType);
            this.setNumberOfNodes(model.numberOfNodes);
            this.setClusterSecurityGroups(model.clusterSecurityGroups);
            this.setVpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.setMasterUserPassword(model.masterUserPassword);
            this.setClusterParameterGroupName(model.clusterParameterGroupName);
            this.setAutomatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setClusterVersion(model.clusterVersion);
            this.setAllowVersionUpgrade(model.allowVersionUpgrade);
            this.setHsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.setHsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.setNewClusterIdentifier(model.newClusterIdentifier);
            this.setPubliclyAccessible(model.publiclyAccessible);
            this.setElasticIp(model.elasticIp);
            this.setEnhancedVpcRouting(model.enhancedVpcRouting);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Collection<String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        @SafeVarargs
        public final void setClusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @SafeVarargs
        public final void setVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getNewClusterIdentifier() {
            return this.newClusterIdentifier;
        }

        @Override
        public final Builder newClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
            return this;
        }

        public final void setNewClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public ModifyClusterRequest build() {
            return new ModifyClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder clusterSecurityGroups(Collection<String> var1);

        public Builder clusterSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder masterUserPassword(String var1);

        public Builder clusterParameterGroupName(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder clusterVersion(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder newClusterIdentifier(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder elasticIp(String var1);

        public Builder enhancedVpcRouting(Boolean var1);
    }
}

