/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroup;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.services.redshift.model.IPRange;
import software.amazon.awssdk.services.redshift.model.IPRangeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterSecurityGroup
implements ToCopyableBuilder<Builder, ClusterSecurityGroup> {
    private final String clusterSecurityGroupName;
    private final String description;
    private final List<EC2SecurityGroup> ec2SecurityGroups;
    private final List<IPRange> ipRanges;
    private final List<Tag> tags;

    private ClusterSecurityGroup(BuilderImpl builder) {
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.description = builder.description;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.tags = builder.tags;
    }

    public String clusterSecurityGroupName() {
        return this.clusterSecurityGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public List<IPRange> ipRanges() {
        return this.ipRanges;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterSecurityGroupName() == null ? 0 : this.clusterSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.ec2SecurityGroups() == null ? 0 : this.ec2SecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.ipRanges() == null ? 0 : this.ipRanges().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSecurityGroup)) {
            return false;
        }
        ClusterSecurityGroup other = (ClusterSecurityGroup)obj;
        if (other.clusterSecurityGroupName() == null ^ this.clusterSecurityGroupName() == null) {
            return false;
        }
        if (other.clusterSecurityGroupName() != null && !other.clusterSecurityGroupName().equals(this.clusterSecurityGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.ec2SecurityGroups() == null ^ this.ec2SecurityGroups() == null) {
            return false;
        }
        if (other.ec2SecurityGroups() != null && !other.ec2SecurityGroups().equals(this.ec2SecurityGroups())) {
            return false;
        }
        if (other.ipRanges() == null ^ this.ipRanges() == null) {
            return false;
        }
        if (other.ipRanges() != null && !other.ipRanges().equals(this.ipRanges())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSecurityGroupName() != null) {
            sb.append("ClusterSecurityGroupName: ").append(this.clusterSecurityGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.ec2SecurityGroups() != null) {
            sb.append("EC2SecurityGroups: ").append(this.ec2SecurityGroups()).append(",");
        }
        if (this.ipRanges() != null) {
            sb.append("IPRanges: ").append(this.ipRanges()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterSecurityGroupName;
        private String description;
        private List<EC2SecurityGroup> ec2SecurityGroups;
        private List<IPRange> ipRanges;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSecurityGroup model) {
            this.setClusterSecurityGroupName(model.clusterSecurityGroupName);
            this.setDescription(model.description);
            this.setEC2SecurityGroups(model.ec2SecurityGroups);
            this.setIPRanges(model.ipRanges);
            this.setTags(model.tags);
        }

        public final String getClusterSecurityGroupName() {
            return this.clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EC2SecurityGroup> getEC2SecurityGroups() {
            return this.ec2SecurityGroups;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        public final void setEC2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
        }

        @SafeVarargs
        public final void setEC2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
        }

        public final Collection<IPRange> getIPRanges() {
            return this.ipRanges;
        }

        @Override
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IPRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIPRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
        }

        @SafeVarargs
        public final void setIPRanges(IPRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public ClusterSecurityGroup build() {
            return new ClusterSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSecurityGroup> {
        public Builder clusterSecurityGroupName(String var1);

        public Builder description(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);

        public Builder ipRanges(Collection<IPRange> var1);

        public Builder ipRanges(IPRange ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

