/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess;
import software.amazon.awssdk.services.redshift.model.Snapshot;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.AccountWithRestoreAccessUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class SnapshotUnmarshaller
implements Unmarshaller<Snapshot, StaxUnmarshallerContext> {
    private static final SnapshotUnmarshaller INSTANCE = new SnapshotUnmarshaller();

    public Snapshot unmarshall(StaxUnmarshallerContext context) throws Exception {
        Snapshot.Builder snapshot;
        block36: {
            snapshot = Snapshot.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<AccountWithRestoreAccess> accountsWithRestoreAccess = null;
            ArrayList<Tag> tags = null;
            ArrayList<String> restorableNodeTypes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    snapshot.accountsWithRestoreAccess(accountsWithRestoreAccess);
                    snapshot.tags(tags);
                    snapshot.restorableNodeTypes(restorableNodeTypes);
                    break block36;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("SnapshotIdentifier", targetDepth)) {
                        snapshot.snapshotIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClusterIdentifier", targetDepth)) {
                        snapshot.clusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotCreateTime", targetDepth)) {
                        snapshot.snapshotCreateTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        snapshot.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Port", targetDepth)) {
                        snapshot.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZone", targetDepth)) {
                        snapshot.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClusterCreateTime", targetDepth)) {
                        snapshot.clusterCreateTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MasterUsername", targetDepth)) {
                        snapshot.masterUsername(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ClusterVersion", targetDepth)) {
                        snapshot.clusterVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnapshotType", targetDepth)) {
                        snapshot.snapshotType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NodeType", targetDepth)) {
                        snapshot.nodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NumberOfNodes", targetDepth)) {
                        snapshot.numberOfNodes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBName", targetDepth)) {
                        snapshot.dbName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        snapshot.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Encrypted", targetDepth)) {
                        snapshot.encrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KmsKeyId", targetDepth)) {
                        snapshot.kmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EncryptedWithHSM", targetDepth)) {
                        snapshot.encryptedWithHSM(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AccountsWithRestoreAccess", targetDepth)) {
                        accountsWithRestoreAccess = new ArrayList<AccountWithRestoreAccess>();
                        continue;
                    }
                    if (context.testExpression("AccountsWithRestoreAccess/AccountWithRestoreAccess", targetDepth)) {
                        accountsWithRestoreAccess.add(AccountWithRestoreAccessUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OwnerAccount", targetDepth)) {
                        snapshot.ownerAccount(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TotalBackupSizeInMegaBytes", targetDepth)) {
                        snapshot.totalBackupSizeInMegaBytes(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ActualIncrementalBackupSizeInMegaBytes", targetDepth)) {
                        snapshot.actualIncrementalBackupSizeInMegaBytes(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BackupProgressInMegaBytes", targetDepth)) {
                        snapshot.backupProgressInMegaBytes(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CurrentBackupRateInMegaBytesPerSecond", targetDepth)) {
                        snapshot.currentBackupRateInMegaBytesPerSecond(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EstimatedSecondsToCompletion", targetDepth)) {
                        snapshot.estimatedSecondsToCompletion(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ElapsedTimeInSeconds", targetDepth)) {
                        snapshot.elapsedTimeInSeconds(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceRegion", targetDepth)) {
                        snapshot.sourceRegion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("Tags/Tag", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RestorableNodeTypes", targetDepth)) {
                        restorableNodeTypes = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("RestorableNodeTypes/NodeType", targetDepth)) {
                        restorableNodeTypes.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EnhancedVpcRouting", targetDepth)) {
                        snapshot.enhancedVpcRouting(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("MaintenanceTrackName", targetDepth)) continue;
                    snapshot.maintenanceTrackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            snapshot.accountsWithRestoreAccess(accountsWithRestoreAccess);
            snapshot.tags(tags);
            snapshot.restorableNodeTypes(restorableNodeTypes);
        }
        return (Snapshot)snapshot.build();
    }

    public static SnapshotUnmarshaller getInstance() {
        return INSTANCE;
    }
}

