/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.RevisionTarget;

public class RevisionTargetUnmarshaller
implements Unmarshaller<RevisionTarget, StaxUnmarshallerContext> {
    private static final RevisionTargetUnmarshaller INSTANCE = new RevisionTargetUnmarshaller();

    public RevisionTarget unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RevisionTarget.Builder revisionTarget = RevisionTarget.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DatabaseRevision", targetDepth)) {
                    revisionTarget.databaseRevision(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    revisionTarget.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DatabaseRevisionReleaseDate", targetDepth)) continue;
                revisionTarget.databaseRevisionReleaseDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RevisionTarget)revisionTarget.build();
    }

    public static RevisionTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

