/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;

public class RestoreTableFromClusterSnapshotRequestMarshaller
implements Marshaller<Request<RestoreTableFromClusterSnapshotRequest>, RestoreTableFromClusterSnapshotRequest> {
    public Request<RestoreTableFromClusterSnapshotRequest> marshall(RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest) {
        if (restoreTableFromClusterSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreTableFromClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "RestoreTableFromClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreTableFromClusterSnapshotRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.clusterIdentifier()));
        }
        if (restoreTableFromClusterSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.snapshotIdentifier()));
        }
        if (restoreTableFromClusterSnapshotRequest.sourceDatabaseName() != null) {
            request.addParameter("SourceDatabaseName", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.sourceDatabaseName()));
        }
        if (restoreTableFromClusterSnapshotRequest.sourceSchemaName() != null) {
            request.addParameter("SourceSchemaName", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.sourceSchemaName()));
        }
        if (restoreTableFromClusterSnapshotRequest.sourceTableName() != null) {
            request.addParameter("SourceTableName", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.sourceTableName()));
        }
        if (restoreTableFromClusterSnapshotRequest.targetDatabaseName() != null) {
            request.addParameter("TargetDatabaseName", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.targetDatabaseName()));
        }
        if (restoreTableFromClusterSnapshotRequest.targetSchemaName() != null) {
            request.addParameter("TargetSchemaName", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.targetSchemaName()));
        }
        if (restoreTableFromClusterSnapshotRequest.newTableName() != null) {
            request.addParameter("NewTableName", StringConversion.fromString((String)restoreTableFromClusterSnapshotRequest.newTableName()));
        }
        return request;
    }
}

