/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;

public class ModifyClusterSubnetGroupRequestMarshaller
implements Marshaller<Request<ModifyClusterSubnetGroupRequest>, ModifyClusterSubnetGroupRequest> {
    public Request<ModifyClusterSubnetGroupRequest> marshall(ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) {
        if (modifyClusterSubnetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyClusterSubnetGroupRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyClusterSubnetGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterSubnetGroupRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringConversion.fromString((String)modifyClusterSubnetGroupRequest.clusterSubnetGroupName()));
        }
        if (modifyClusterSubnetGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)modifyClusterSubnetGroupRequest.description()));
        }
        if (modifyClusterSubnetGroupRequest.subnetIds().isEmpty() && !(modifyClusterSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetIds", "");
        } else if (!modifyClusterSubnetGroupRequest.subnetIds().isEmpty() && !(modifyClusterSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            List<String> subnetIdsList = modifyClusterSubnetGroupRequest.subnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringConversion.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        return request;
    }
}

