/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;

public class ModifyClusterDbRevisionRequestMarshaller
implements Marshaller<Request<ModifyClusterDbRevisionRequest>, ModifyClusterDbRevisionRequest> {
    public Request<ModifyClusterDbRevisionRequest> marshall(ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest) {
        if (modifyClusterDbRevisionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyClusterDbRevisionRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyClusterDbRevision");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterDbRevisionRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)modifyClusterDbRevisionRequest.clusterIdentifier()));
        }
        if (modifyClusterDbRevisionRequest.revisionTarget() != null) {
            request.addParameter("RevisionTarget", StringConversion.fromString((String)modifyClusterDbRevisionRequest.revisionTarget()));
        }
        return request;
    }
}

