/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.EventSubscription;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class EventSubscriptionUnmarshaller
implements Unmarshaller<EventSubscription, StaxUnmarshallerContext> {
    private static final EventSubscriptionUnmarshaller INSTANCE = new EventSubscriptionUnmarshaller();

    public EventSubscription unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventSubscription.Builder eventSubscription;
        block17: {
            eventSubscription = EventSubscription.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<String> sourceIdsList = null;
            ArrayList<String> eventCategoriesList = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    eventSubscription.sourceIdsList(sourceIdsList);
                    eventSubscription.eventCategoriesList(eventCategoriesList);
                    eventSubscription.tags(tags);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("CustomerAwsId", targetDepth)) {
                        eventSubscription.customerAwsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CustSubscriptionId", targetDepth)) {
                        eventSubscription.custSubscriptionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SnsTopicArn", targetDepth)) {
                        eventSubscription.snsTopicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Status", targetDepth)) {
                        eventSubscription.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SubscriptionCreationTime", targetDepth)) {
                        eventSubscription.subscriptionCreationTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceType", targetDepth)) {
                        eventSubscription.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SourceIdsList", targetDepth)) {
                        sourceIdsList = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SourceIdsList/SourceId", targetDepth)) {
                        sourceIdsList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EventCategoriesList", targetDepth)) {
                        eventCategoriesList = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("EventCategoriesList/EventCategory", targetDepth)) {
                        eventCategoriesList.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Severity", targetDepth)) {
                        eventSubscription.severity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Enabled", targetDepth)) {
                        eventSubscription.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            eventSubscription.sourceIdsList(sourceIdsList);
            eventSubscription.eventCategoriesList(eventCategoriesList);
            eventSubscription.tags(tags);
        }
        return (EventSubscription)eventSubscription.build();
    }

    public static EventSubscriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

