/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;

public class DescribeOrderableClusterOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableClusterOptionsRequest>, DescribeOrderableClusterOptionsRequest> {
    public Request<DescribeOrderableClusterOptionsRequest> marshall(DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        if (describeOrderableClusterOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeOrderableClusterOptionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeOrderableClusterOptions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableClusterOptionsRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringConversion.fromString((String)describeOrderableClusterOptionsRequest.clusterVersion()));
        }
        if (describeOrderableClusterOptionsRequest.nodeType() != null) {
            request.addParameter("NodeType", StringConversion.fromString((String)describeOrderableClusterOptionsRequest.nodeType()));
        }
        if (describeOrderableClusterOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeOrderableClusterOptionsRequest.maxRecords()));
        }
        if (describeOrderableClusterOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeOrderableClusterOptionsRequest.marker()));
        }
        return request;
    }
}

