/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;

public class DescribeEventSubscriptionsRequestMarshaller
implements Marshaller<Request<DescribeEventSubscriptionsRequest>, DescribeEventSubscriptionsRequest> {
    public Request<DescribeEventSubscriptionsRequest> marshall(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        if (describeEventSubscriptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeEventSubscriptionsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeEventSubscriptions");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventSubscriptionsRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringConversion.fromString((String)describeEventSubscriptionsRequest.subscriptionName()));
        }
        if (describeEventSubscriptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeEventSubscriptionsRequest.maxRecords()));
        }
        if (describeEventSubscriptionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeEventSubscriptionsRequest.marker()));
        }
        if (describeEventSubscriptionsRequest.tagKeys().isEmpty() && !(describeEventSubscriptionsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeEventSubscriptionsRequest.tagKeys().isEmpty() && !(describeEventSubscriptionsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeEventSubscriptionsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeEventSubscriptionsRequest.tagValues().isEmpty() && !(describeEventSubscriptionsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeEventSubscriptionsRequest.tagValues().isEmpty() && !(describeEventSubscriptionsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeEventSubscriptionsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

