/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;

public class DescribeClusterTracksRequestMarshaller
implements Marshaller<Request<DescribeClusterTracksRequest>, DescribeClusterTracksRequest> {
    public Request<DescribeClusterTracksRequest> marshall(DescribeClusterTracksRequest describeClusterTracksRequest) {
        if (describeClusterTracksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClusterTracksRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterTracks");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterTracksRequest.maintenanceTrackName() != null) {
            request.addParameter("MaintenanceTrackName", StringConversion.fromString((String)describeClusterTracksRequest.maintenanceTrackName()));
        }
        if (describeClusterTracksRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClusterTracksRequest.maxRecords()));
        }
        if (describeClusterTracksRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClusterTracksRequest.marker()));
        }
        return request;
    }
}

