/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;

public class DescribeClusterSubnetGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterSubnetGroupsRequest>, DescribeClusterSubnetGroupsRequest> {
    public Request<DescribeClusterSubnetGroupsRequest> marshall(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        if (describeClusterSubnetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeClusterSubnetGroupsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSubnetGroups");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSubnetGroupsRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringConversion.fromString((String)describeClusterSubnetGroupsRequest.clusterSubnetGroupName()));
        }
        if (describeClusterSubnetGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeClusterSubnetGroupsRequest.maxRecords()));
        }
        if (describeClusterSubnetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeClusterSubnetGroupsRequest.marker()));
        }
        if (describeClusterSubnetGroupsRequest.tagKeys().isEmpty() && !(describeClusterSubnetGroupsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeClusterSubnetGroupsRequest.tagKeys().isEmpty() && !(describeClusterSubnetGroupsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeClusterSubnetGroupsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeClusterSubnetGroupsRequest.tagValues().isEmpty() && !(describeClusterSubnetGroupsRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeClusterSubnetGroupsRequest.tagValues().isEmpty() && !(describeClusterSubnetGroupsRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeClusterSubnetGroupsRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

