/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;

public class DeleteClusterRequestMarshaller
implements Marshaller<Request<DeleteClusterRequest>, DeleteClusterRequest> {
    public Request<DeleteClusterRequest> marshall(DeleteClusterRequest deleteClusterRequest) {
        if (deleteClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteClusterRequest, "RedshiftClient");
        request.addParameter("Action", "DeleteCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)deleteClusterRequest.clusterIdentifier()));
        }
        if (deleteClusterRequest.skipFinalClusterSnapshot() != null) {
            request.addParameter("SkipFinalClusterSnapshot", StringConversion.fromBoolean((Boolean)deleteClusterRequest.skipFinalClusterSnapshot()));
        }
        if (deleteClusterRequest.finalClusterSnapshotIdentifier() != null) {
            request.addParameter("FinalClusterSnapshotIdentifier", StringConversion.fromString((String)deleteClusterRequest.finalClusterSnapshotIdentifier()));
        }
        return request;
    }
}

