/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;

public class AcceptReservedNodeExchangeRequestMarshaller
implements Marshaller<Request<AcceptReservedNodeExchangeRequest>, AcceptReservedNodeExchangeRequest> {
    public Request<AcceptReservedNodeExchangeRequest> marshall(AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) {
        if (acceptReservedNodeExchangeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)acceptReservedNodeExchangeRequest, "RedshiftClient");
        request.addParameter("Action", "AcceptReservedNodeExchange");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (acceptReservedNodeExchangeRequest.reservedNodeId() != null) {
            request.addParameter("ReservedNodeId", StringConversion.fromString((String)acceptReservedNodeExchangeRequest.reservedNodeId()));
        }
        if (acceptReservedNodeExchangeRequest.targetReservedNodeOfferingId() != null) {
            request.addParameter("TargetReservedNodeOfferingId", StringConversion.fromString((String)acceptReservedNodeExchangeRequest.targetReservedNodeOfferingId()));
        }
        return request;
    }
}

