/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;

public class DescribeClusterSecurityGroupsIterable
implements SdkIterable<DescribeClusterSecurityGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterSecurityGroupsIterable(RedshiftClient client, DescribeClusterSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSecurityGroup> clusterSecurityGroups() {
        Function<DescribeClusterSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSecurityGroups() != null) {
                return response.clusterSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeClusterSecurityGroupsIterable resume(DescribeClusterSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterSecurityGroupsIterable(this.client, (DescribeClusterSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterSecurityGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClusterSecurityGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClusterSecurityGroupsResponseFetcher
    implements SyncPageFetcher<DescribeClusterSecurityGroupsResponse> {
        private DescribeClusterSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeClusterSecurityGroupsResponse nextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSecurityGroupsIterable.this.client.describeClusterSecurityGroups(DescribeClusterSecurityGroupsIterable.this.firstRequest);
            }
            return DescribeClusterSecurityGroupsIterable.this.client.describeClusterSecurityGroups((DescribeClusterSecurityGroupsRequest)((Object)DescribeClusterSecurityGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

