/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSnapshotCopyStatus
implements ToCopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
    private final String destinationRegion;
    private final Long retentionPeriod;
    private final String snapshotCopyGrantName;

    private ClusterSnapshotCopyStatus(BuilderImpl builder) {
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Long retentionPeriod() {
        return this.retentionPeriod;
    }

    public String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyGrantName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshotCopyStatus)) {
            return false;
        }
        ClusterSnapshotCopyStatus other = (ClusterSnapshotCopyStatus)obj;
        return Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.snapshotCopyGrantName(), other.snapshotCopyGrantName());
    }

    public String toString() {
        return ToString.builder((String)"ClusterSnapshotCopyStatus").add("DestinationRegion", (Object)this.destinationRegion()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("SnapshotCopyGrantName", (Object)this.snapshotCopyGrantName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "SnapshotCopyGrantName": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyGrantName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationRegion;
        private Long retentionPeriod;
        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshotCopyStatus model) {
            this.destinationRegion(model.destinationRegion);
            this.retentionPeriod(model.retentionPeriod);
            this.snapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Long getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        public ClusterSnapshotCopyStatus build() {
            return new ClusterSnapshotCopyStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
        public Builder destinationRegion(String var1);

        public Builder retentionPeriod(Long var1);

        public Builder snapshotCopyGrantName(String var1);
    }
}

