/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;

public class ModifyClusterRequestMarshaller
implements Marshaller<Request<ModifyClusterRequest>, ModifyClusterRequest> {
    public Request<ModifyClusterRequest> marshall(ModifyClusterRequest modifyClusterRequest) {
        List<String> vpcSecurityGroupIdsList;
        List<String> clusterSecurityGroupsList;
        if (modifyClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyClusterRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)modifyClusterRequest.clusterIdentifier()));
        }
        if (modifyClusterRequest.clusterType() != null) {
            request.addParameter("ClusterType", StringUtils.fromString((String)modifyClusterRequest.clusterType()));
        }
        if (modifyClusterRequest.nodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)modifyClusterRequest.nodeType()));
        }
        if (modifyClusterRequest.numberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringUtils.fromInteger((Integer)modifyClusterRequest.numberOfNodes()));
        }
        if ((clusterSecurityGroupsList = modifyClusterRequest.clusterSecurityGroups()) != null) {
            if (!clusterSecurityGroupsList.isEmpty()) {
                int clusterSecurityGroupsListIndex = 1;
                for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                    if (clusterSecurityGroupsListValue != null) {
                        request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)clusterSecurityGroupsListValue));
                    }
                    ++clusterSecurityGroupsListIndex;
                }
            } else {
                request.addParameter("ClusterSecurityGroups", "");
            }
        }
        if ((vpcSecurityGroupIdsList = modifyClusterRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (modifyClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyClusterRequest.masterUserPassword()));
        }
        if (modifyClusterRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)modifyClusterRequest.clusterParameterGroupName()));
        }
        if (modifyClusterRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)modifyClusterRequest.automatedSnapshotRetentionPeriod()));
        }
        if (modifyClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyClusterRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringUtils.fromString((String)modifyClusterRequest.clusterVersion()));
        }
        if (modifyClusterRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyClusterRequest.allowVersionUpgrade()));
        }
        if (modifyClusterRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)modifyClusterRequest.hsmClientCertificateIdentifier()));
        }
        if (modifyClusterRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)modifyClusterRequest.hsmConfigurationIdentifier()));
        }
        if (modifyClusterRequest.newClusterIdentifier() != null) {
            request.addParameter("NewClusterIdentifier", StringUtils.fromString((String)modifyClusterRequest.newClusterIdentifier()));
        }
        if (modifyClusterRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)modifyClusterRequest.publiclyAccessible()));
        }
        if (modifyClusterRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)modifyClusterRequest.elasticIp()));
        }
        if (modifyClusterRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringUtils.fromBoolean((Boolean)modifyClusterRequest.enhancedVpcRouting()));
        }
        return request;
    }
}

