/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.Parameter;

public class ModifyClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyClusterParameterGroupRequest>, ModifyClusterParameterGroupRequest> {
    public Request<ModifyClusterParameterGroupRequest> marshall(ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) {
        List<Parameter> parametersList;
        if (modifyClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyClusterParameterGroupRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClusterParameterGroupRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)modifyClusterParameterGroupRequest.parameterGroupName()));
        }
        if ((parametersList = modifyClusterParameterGroupRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue.parameterName() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringUtils.fromString((String)parametersListValue.parameterName()));
                    }
                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.parameterValue()));
                    }
                    if (parametersListValue.description() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringUtils.fromString((String)parametersListValue.description()));
                    }
                    if (parametersListValue.source() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringUtils.fromString((String)parametersListValue.source()));
                    }
                    if (parametersListValue.dataType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringUtils.fromString((String)parametersListValue.dataType()));
                    }
                    if (parametersListValue.allowedValues() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringUtils.fromString((String)parametersListValue.allowedValues()));
                    }
                    if (parametersListValue.applyTypeAsString() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringUtils.fromString((String)parametersListValue.applyTypeAsString()));
                    }
                    if (parametersListValue.isModifiable() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean((Boolean)parametersListValue.isModifiable()));
                    }
                    if (parametersListValue.minimumEngineVersion() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringUtils.fromString((String)parametersListValue.minimumEngineVersion()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        return request;
    }
}

