/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;

public class CopyClusterSnapshotRequestMarshaller
implements Marshaller<Request<CopyClusterSnapshotRequest>, CopyClusterSnapshotRequest> {
    public Request<CopyClusterSnapshotRequest> marshall(CopyClusterSnapshotRequest copyClusterSnapshotRequest) {
        if (copyClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)copyClusterSnapshotRequest, "RedshiftClient");
        request.addParameter("Action", "CopyClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyClusterSnapshotRequest.sourceSnapshotIdentifier() != null) {
            request.addParameter("SourceSnapshotIdentifier", StringUtils.fromString((String)copyClusterSnapshotRequest.sourceSnapshotIdentifier()));
        }
        if (copyClusterSnapshotRequest.sourceSnapshotClusterIdentifier() != null) {
            request.addParameter("SourceSnapshotClusterIdentifier", StringUtils.fromString((String)copyClusterSnapshotRequest.sourceSnapshotClusterIdentifier()));
        }
        if (copyClusterSnapshotRequest.targetSnapshotIdentifier() != null) {
            request.addParameter("TargetSnapshotIdentifier", StringUtils.fromString((String)copyClusterSnapshotRequest.targetSnapshotIdentifier()));
        }
        return request;
    }
}

