/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;

public class DescribeReservedNodesIterable
implements SdkIterable<DescribeReservedNodesResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodesIterable(RedshiftClient client, DescribeReservedNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodesResponseFetcher();
    }

    public Iterator<DescribeReservedNodesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ReservedNode> reservedNodes() {
        Function<DescribeReservedNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodes() != null) {
                return response.reservedNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeReservedNodesIterable resume(DescribeReservedNodesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedNodesIterable(this.client, (DescribeReservedNodesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedNodesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedNodesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedNodesResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodesResponse> {
        private DescribeReservedNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedNodesResponse nextPage(DescribeReservedNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesIterable.this.client.describeReservedNodes(DescribeReservedNodesIterable.this.firstRequest);
            }
            return DescribeReservedNodesIterable.this.client.describeReservedNodes((DescribeReservedNodesRequest)((Object)DescribeReservedNodesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

